<?xml version="1.0" encoding="UTF-8" ?>



<!--

    Document   : tree.xsl

    Created on : October 8, 2003, 10:15 AM

    Author     : andrew

    Description:

        Purpose of transformation follows.

-->



<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html"/>



<!--	<xsl:param name='tagName' select="'source'"/> -->

		

	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>

	

	<xsl:template match="/">

		<table border="0" cellpadding="0" cellspacing="0">

			<xsl:apply-templates select='source/source'/>

		</table>

	</xsl:template>

	

	<xsl:template match='source'>

		<tr treeId='{@id}' treeLevel='{count(ancestor::source)}'>

			<td class='TreeRowTD' noWrap='true'>

				<span class='treeIndent2'>

					<xsl:for-each select='ancestor::source[parent::source]'>

						<span><xsl:attribute name='class'><xsl:choose><xsl:when test='following-sibling::source'>Left</xsl:when><xsl:otherwise>Right</xsl:otherwise></xsl:choose></xsl:attribute>&#160;</span><span class='Right'>&#160;</span>

					</xsl:for-each>

					<span class='Left'>&#160;</span>

					<img class='treeStatus'><xsl:attribute name='src'>../apt/images/<xsl:choose>

						<xsl:when test='source'>tree-minuts</xsl:when>

						<xsl:otherwise>tree-leaf</xsl:otherwise>

					</xsl:choose>.gif</xsl:attribute></img>

				</span><a class='titoAnchor' href='javascript:' title='{@name}' tabIndex='0'>

					<xsl:if test='@type'><img class='mimeType' src='images/types.{@type}.gif' border='0'/></xsl:if><xsl:choose><xsl:when test='@urlName'><xsl:value-of select='@urlName'/></xsl:when><xsl:otherwise><xsl:value-of select='@name'/></xsl:otherwise></xsl:choose></a></td>

		</tr>

		<xsl:apply-templates/>

	</xsl:template>



    <!-- <xsl:template match="/">

        <html>

            <head>

                <title>tree.xsl</title>

                <LINK href='../../apt/views/tree.css' type="text/css" REL="STYLESHEET"/>

				<script src="tree.js">//</script>

            </head>

            <body>

                <table border="0" cellpadding="0" cellspacing="0" style='width:100%'>

                <xsl:apply-templates/>

                </table>

            </body>

        </html>

    </xsl:template> -->



</xsl:stylesheet>

